# Windows 11 Honest Mode
# Host: console
# Options: Show telemetry settings; Show startup apps; Show scheduled tasks

param([string]$choice)

switch ($choice) {
    "Show telemetry settings" {
        Write-Host "Telemetry settings:"
        Get-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DataCollection" |
            Format-List
    }
    "Show startup apps" {
        Write-Host "Startup apps:"
        Get-CimInstance Win32_StartupCommand |
            Select-Object Name, Command, Location | Format-Table -AutoSize
    }
    "Show scheduled tasks" {
        Write-Host "Scheduled tasks:"
        Get-ScheduledTask | Where-Object {$_.TaskPath -notlike "\Microsoft*"} |
            Select-Object TaskName, State | Format-Table -AutoSize
    }
}
